<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">

    <title>Terms of Service - ArloMusic</title>
    <style>
        body {
            font-family: 'Nunito', sans-serif;
            color: white;
        }

        /* Terms of Service styling */
        .policy-section {
            margin-bottom: 20px;
        }

        .policy-section h2 {
            font-size: 1.8em;
            color: #007bff;
            margin-bottom: 10px;
        }

        .policy-section p, .policy-section ul {
            font-size: 1em;
            color: white;
            margin: 10px 0;
        }
        @media (max-width: 768px) {
    html, body {
    overflow-x: hidden;
    }
       /* Hamburger icon styles */
       .hamburger {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
    padding: 10px;
    z-index: 10; /* Make sure the hamburger icon stays above the menu */
    }

    .hamburger .bar {
    width: 25px;
    height: 3px;
    background-color: white;
    transition: 0.4s;
    }

    .nav-links {
        position: fixed;
        top: 0px;
        right: -60%; /* Start off-screen */
        height: 100vh;
        width: 40%; /* Cover half the screen */
        background-color: #000000c7;
        border-left: 0.5px solid white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        transition: right 0.4s ease; /* Smooth slide-in effect */
        z-index: 9; /* Keep the menu below the hamburger icon */
    }

    .nav-links ul {
        flex-direction: column;
        width: 100%;
    }

    .nav-links ul li {
        display: block;
        padding: 15px 0;
        
    }

    /* Show hamburger icon only on mobile */
    .hamburger {
        display: flex;
    }

    /* When active, slide the menu into view */
    .nav-links.active {
        right: -7%;
        }
    
    .hamburger {
        display: flex;
        position: relative; /* Keeps it at the top right of the screen initially */
        right: 10px;
        z-index: 11; /* Above the menu */
    }

    /* Position hamburger icon "inside" menu when it’s open */
    .hamburger.active {
        position: fixed; /* Repositions icon relative to .nav-links */

        right: 10px;
        z-index: 11; /* Above the sliding menu content */
    }
    .Account{
        margin-left: -20px;
        margin-top: 10px;
    }
}
    </style>
</head>
<body>
    <section class="header" id="NavSection">
        <nav class="navbar">
            <a href="index.php"><img class="LogoIcon" src="Images/Logo1.png" alt="ArloMusic_Logo"></a>
            <div class="hamburger" id="hamburger" onclick="toggleMenu()">
        <div class="bar"></div>
        <div class="bar"></div>
        <div class="bar"></div>
    </div>
            <div class="nav-links" id="navLinks">
            <ul>
            <li class="navButton"><a href="Logged.php">Home</a></li>
                <li class="navButton"><a href="TopPageLogged.php">Top</a></li>
                <li class="navButton"><a href="ArtistsPage.php">Artists</a></li>
                <li class="navButton"><a href="LogoutSession.php">Log out</a></li>
                <li><a href="AccountInfo.php"><img  class="Account" src="Images/pfp.png" alt="Profile_Picture"></a></li>
            </ul>
        </div>
        </nav>
        <div class="HeaderLow">
            <h1>Terms of Service</h1>
            <div class="policy-section">
                <h2>1. Introduction</h2>
                <p>Welcome to ArloMusic! These Terms of Service govern your access to and use of our website and services. By accessing or using ArloMusic, you agree to abide by these Terms. If you disagree with any part of these Terms, please refrain from using our services.</p>
            </div>
            
            <div class="policy-section">
                <h2>2. Account Creation</h2>
                <p>To access certain features of ArloMusic, you may need to create an account. When you create an account, you agree to provide accurate and up-to-date information. You are responsible for maintaining the confidentiality of your account details, and you accept responsibility for all activities under your account.</p>
            </div>

            <div class="policy-section">
                <h2>3. Acceptable Use</h2>
                <p>By using ArloMusic, you agree to use the platform for lawful purposes only. You are prohibited from uploading, sharing, or transmitting any content that is illegal, offensive, harmful, or that infringes on the rights of others. We reserve the right to suspend or terminate accounts that violate our Acceptable Use Policy.</p>
            </div>

            <div class="policy-section">
                <h2>4. Intellectual Property</h2>
                <p>All content on ArloMusic, including but not limited to text, graphics, logos, and software, is the property of ArloMusic or its licensors and is protected by copyright, trademark, and other intellectual property laws. You may not copy, modify, distribute, or use any of our content without our prior written consent.</p>
            </div>

            <div class="policy-section">
                <h2>5. User Content</h2>
                <p>By sharing or posting content on ArloMusic, you grant us a non-exclusive, worldwide, royalty-free license to use, display, distribute, and promote your content on our platform and related marketing. You retain ownership of your content but are responsible for ensuring it complies with our Terms and is free from third-party claims.</p>
            </div>

            <div class="policy-section">
                <h2>6. Limitation of Liability</h2>
                <p>ArloMusic is provided on an "as-is" and "as-available" basis. We make no guarantees that our services will be uninterrupted, secure, or error-free. ArloMusic is not liable for any damages arising from your use of our platform or your reliance on any content available through our services.</p>
            </div>

            <div class="policy-section">
                <h2>7. Modifications to Terms</h2>
                <p>We may update these Terms periodically. When we make changes, we will notify users by updating the date at the top of this page. Your continued use of ArloMusic after the changes take effect constitutes acceptance of the updated Terms.</p>
            </div>

            <div class="policy-section">
                <h2>8. Termination</h2>
                <p>We reserve the right to suspend or terminate your access to ArloMusic at any time, with or without notice, for violating these Terms or engaging in any activities that harm the platform, other users, or our community.</p>
            </div>

            <div class="policy-section">
                <h2>9. Governing Law</h2>
                <p>These Terms are governed by and construed in accordance with the laws of [Your Country/State]. Any disputes arising under these Terms shall be resolved in the courts of [Your Jurisdiction].</p>
            </div>

            <div class="policy-section">
                <h2>10. Contact Us</h2>
                <p>If you have any questions or concerns about these Terms of Service, please contact us at:</p>
                <p><strong>ArloMusic Support Team</strong><br>
                Email: <a href="mailto:contact@arlomusic.com">contact@arlomusic.com</a><br>
                Website: <a href="https://arlomusic.com">https://arlomusic.com</a></p>
            </div>
        </div>
        <br>
    </section>
    
    <hr>
    <section class="Footer">
        <div class="FooterContent">
            <div class="FooterLinks">
                <ul>
                <li><a href="Logged.php">About Us</a></li>
                    <li><a href="contactLogged.php">Contact Us</a></li>
                    <li><a href="policyLogged.php">Privacy Policy</a></li>
                    <li><a href="TOSlogged.php">Terms of Service</a></li>
                </ul>
            </div>
            <div class="FooterSocials">
                <ul>
                    <li><a href=""><img src="Images/facebook.png" alt=""></a></li>
                    <li><a href=""><img src="Images/twitter.png" alt=""></a></li>
                    <li><a href=""><img src="Images/instagram.png" alt=""></a></li>
                </ul>
            </div>
        </div>
        <h1>Copyright © 2024 ArloMusic All rights reserved.</h1>
    </section>
    <script>
    function toggleMenu() {
        const navLinks = document.getElementById("navLinks");
        navLinks.classList.toggle("active");
        const hamburger = document.getElementById("hamburger");
        hamburger.classList.toggle("active");
    }
</script>
</body>
</html>
